/**
 * 
 */
package gov.va.med.mhv.vitals.web.pgd;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;

import ca.uhn.fhir.rest.client.api.IClientInterceptor;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpResponse;

/**
 * @author DNS
 *
 * Interceptor responsible for capturing the updated JWT authentication
 * token in response to a call to a VAMF secure web service endpoint.
 */
public class JwtAuthResponseInterceptor implements IClientInterceptor {
	
	private static final Log LOG = LogFactoryUtil.getLog(JwtAuthResponseInterceptor.class);
	
	private static final String VAMF_JWT_TOKEN_ATTR_NAME = "MhvVitalsVamfAuthenticatedJwt";
	
	private static final String JWT_RESPONSE_HEADER = "";
	
	/**
	 * 
	 */
	public JwtAuthResponseInterceptor() {
		// TODO Auto-generated constructor stub
	}

	/* (non-Javadoc)
	 * @see ca.uhn.fhir.rest.client.api.IClientInterceptor#interceptRequest(ca.uhn.fhir.rest.client.api.IHttpRequest)
	 */
	@Override
	public void interceptRequest(IHttpRequest theRequest) {
		// Nothing to do here.

	}

	/* (non-Javadoc)
	 * @see ca.uhn.fhir.rest.client.api.IClientInterceptor#interceptResponse(ca.uhn.fhir.rest.client.api.IHttpResponse)
	 */
	@Override
	public void interceptResponse(IHttpResponse theResponse) throws IOException {
		HttpSession session = null;
		
		try {
			Map<String, List<String>> allHeadersMap = theResponse.getAllHeaders();
			if(LOG.isDebugEnabled()) {
				for(String key : allHeadersMap.keySet()) {
					StringBuffer sbHeaderValues = new StringBuffer();
					sbHeaderValues.append("[");
					for(String val : allHeadersMap.get(key)) {
						if(sbHeaderValues.length() > 1) {
							sbHeaderValues.append(',');
						}
						sbHeaderValues.append("\"").append(val).append("\"");
					}
					sbHeaderValues.append("]");
					LOG.debug(String.format("Header key: %s, value: %s", key, sbHeaderValues.toString()));
				}
			}
			
			String jwtAuthToken = allHeadersMap.get(JWT_RESPONSE_HEADER).get(0);
			if(jwtAuthToken != null && jwtAuthToken.length() != 0) {

				if(LOG.isDebugEnabled()) {
					LOG.debug("Updating VAMF JWT Auth Token.");
				}
				
				session = PortalSessionThreadLocal.getHttpSession();
				
				if(session != null) {
					session.setAttribute(VAMF_JWT_TOKEN_ATTR_NAME, jwtAuthToken);
				} 
				else {
					LOG.error("Session is null. Unable to update token.");
				}
			}
			
		} catch (Throwable t) {
			String errorMessage = String.format("An error occurred while retrieving %s token from the response headers.", JWT_RESPONSE_HEADER);
			LOG.error(errorMessage);
			throw new IOException(errorMessage, t);
		}

	}

}
